<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English */
$specialPageAliases['en'] = [
	'LookupUser' => [ 'LookupUser' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'LookupUser' => [ 'مطالعة_مستخدم' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'LookupUser' => [ 'شوف_يوزر' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'LookupUser' => [ 'کارمرزوکی_گشتین' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'LookupUser' => [ 'Itihi_pamakai' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'LookupUser' => [ 'PronadjiKorisnika' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'LookupUser' => [ 'Benutzerdaten_einsehen' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'LookupUser' => [ 'KarberBıvin' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'LookupUser' => [ 'جستجوی_کاربر' ],
];

/** Gagauz (Gagauz) */
$specialPageAliases['gag'] = [
	'LookupUser' => [ 'KullanıcıAra' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'LookupUser' => [ 'Benutzerdate_noochluege' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'LookupUser' => [ 'Pogledaj_suradnika' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'LookupUser' => [ 'GadeItilizatè' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'LookupUser' => [ 'Cercar_usator' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'LookupUser' => [ 'Lihat_pengguna', 'LihatPengguna' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'LookupUser' => [ 'ControllaUtente' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'LookupUser' => [ '利用者情報調査', '利用者情報を調査' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'LookupUser' => [ '사용자찾기' ],
];

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = [
	'LookupUser' => [ 'Metmaacher_Nohloore', 'MetmaacherNohloore', 'Medmaacher_Nohloore', 'MedmaacherNohloore' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'LookupUser' => [ 'BuscaUsador' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'LookupUser' => [ 'Benotzer_nokucken' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'LookupUser' => [ 'ПобарајГоКорисникот', 'ПобарајКорисник' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'LookupUser' => [ 'ഉപയോക്താവിനെനോക്കുക' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'LookupUser' => [ 'Finn_bruker' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'LookupUser' => [ 'Gebruker_opzeuken' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'LookupUser' => [ 'GebruikerOpzoeken' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'LookupUser' => [ 'योजकपश्यन्तु' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'LookupUser' => [ 'ControllaUtente' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'LookupUser' => [ 'VyhľadaniePoužívateľa' ],
];

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = [
	'LookupUser' => [ 'TafutaMtumiaji' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'LookupUser' => [ 'Hanapin_ang_tagagamit' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'LookupUser' => [ 'KullanıcıAra' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'LookupUser' => [ '查阅用户' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'LookupUser' => [ '搜尋使用者' ],
];
