<?php

/**
 * Internationalization file for the Include WP extension.
 *
 * @since 0.1
 *
 * @file IncludeWP.i18n.php
 * @ingroup IncludeWP
 *
 * @licence GNU GPL v3 or later
 *
 * @author Jeroen De Dauw < jeroendedauw@gmail.com >
 */

$messages = array();

/** English
 * @author Jeroen De Dauw
 */
$messages['en'] = array(
	'includewp-desc' => 'IncludeWP is a lightweight extension for including Wikipedia content',

	'includewp-loading-page' => 'Loading page...',
	'includewp-show-full-page' => 'Show full page',                                 
	'includewp-show-fragment' => 'Only show the first paragraph',
	'includewp-loading-failed' => 'Failed to load page.',

	'includewp-licence-notice' => 'The above content comes from the $1 page <a href="$2">$3</a> licenced under the <a href="$4">$5</a>. A full list of authors can be found <a href="$6">here</a>.',
	
	'includewp-parserhook-desc' => 'Parser hook that allows displaying content of a Wikipedia page.',
	'includewp-include-par-page' => 'The name of the (remote) page you want to display.',
	'includewp-include-par-wiki' => 'The name of the wiki you want to pull content from. Needs to be one of the allowed wikis, by default only wikipedia.',
	'includewp-include-par-paragraphs' => 'The number of paragraphs you want to initially display.',
	'includewp-include-par-height' => 'The max height (in px) of the div into which the content is loaded. Set to 0 for no limit.',
);

/** Message documentation (Message documentation)
 * @author Kghbln
 */
$messages['qqq'] = array(
	'includewp-licence-notice' => '$1 stands for the sitename',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'includewp-desc' => "IncludeWP is 'n liggewig uitbreiding om Wikipedia inhoud by u wiki in te sluit",
	'includewp-loading-page' => 'Laai bladsy...',
	'includewp-show-full-page' => 'Wys volledige bladsy',
	'includewp-loading-failed' => 'Laai van bladsy het gefaal.',
	'includewp-licence-notice' => 'Bostaande inhoud kom vanaf die $1-artikel <a href="$2">$3</a> gelisensieerd onder die <a href="$4">$5</a>. \'n Volledige lys van outeurs is <a href="$6">hier</a> beskikbaar.',
	'includewp-parserhook-desc' => 'Ontleder-hoek wat die vertoon van inhoud vanuit Wikipedia-artikels moontlik maak.',
	'includewp-include-par-page' => 'Die naam van die (afgeleë) bladsy om te vertoon.',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 */
$messages['be-tarask'] = array(
	'includewp-desc' => 'IncludeWP — невялікае пашырэньне для ўключэньня зьместу Вікіпэдыі',
	'includewp-loading-page' => 'Загрузка старонкі…',
	'includewp-show-full-page' => 'Паказаць старонку цалкам',
	'includewp-show-fragment' => 'Паказаць толькі першы параграф',
	'includewp-loading-failed' => 'Немагчыма загрузіць старонку.',
	'includewp-licence-notice' => 'Пададзены вышэй зьмест паходзіць са старонкі $1 <a href="$2">$3</a> на ўмовах ліцэнзіі <a href="$4">$5</a>. Поўны сьпіс аўтараў можна знайсьці <a href="$6">тут</a>.',
	'includewp-parserhook-desc' => 'Працэдура-перахопнік парсэру, які дазваляе паказваць зьмест старонкі Вікіпэдыі.',
	'includewp-include-par-page' => 'Назва (аддаленай) старонкі, якую Вы жадаеце паказаць.',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'includewp-desc' => 'Ermöglicht das Einbeziehen von Inhalten der Wikipedia in ein Wiki',
	'includewp-loading-page' => 'Lade Seite …',
	'includewp-show-full-page' => 'Seite vollständig anzeigen',
	'includewp-show-fragment' => 'Lediglich den ersten Absatz anzeigen',
	'includewp-loading-failed' => 'Das Laden der Seite ist gescheitert.',
	'includewp-licence-notice' => 'Der obige Inhalt stammt vom $1-Artikel <a href="$2">„$3“</a>, der gemäß <a href="$4">$5</a> lizenziert wurde. Eine vollständige Liste der Autoren ist <a href="$6">hier</a> verfügbar.',
	'includewp-parserhook-desc' => 'Parserhook der das Anzeigen von Inhalten eines Wikipedia-Artikels ermöglicht.',
	'includewp-include-par-page' => 'Der Name der Seite, die angezeigt werden soll.',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'includewp-desc' => 'IncludeWP היא הרחבה פשוטה להכללת תוכן של ויקיפדיה',
	'includewp-loading-page' => 'הדף בטעינה...',
	'includewp-show-full-page' => 'להציג דף מלא',
	'includewp-show-fragment' => 'להציג רק את הפסקה הראשונה',
	'includewp-loading-failed' => 'טעינת הדף נכשלה.',
	'includewp-licence-notice' => 'התוכן לעיל מגיע מהדף <a href="$2">$3</a> באתר $1, והוא מתפרסם ברישיון <a href="$4">$5</a>. רשימה מלאה של מחבריו נמצאת <a href="$6">כאן</a>.',
	'includewp-parserhook-desc' => 'וו מפענח שמאפשר הצגת תוכן של דף ויקיפדיה.',
	'includewp-include-par-page' => 'שם הדף המרוחק שאתם רוצים להציג.',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'includewp-desc' => 'IncludeWP je jednore rozšěrjenje za zapřijimowanje wobsaha Wikipedije',
	'includewp-loading-page' => 'Strona so začituje...',
	'includewp-show-full-page' => 'Dospołnu stronu pokazać',
	'includewp-show-fragment' => 'Jenož prěni wotstawk pokazać',
	'includewp-loading-failed' => 'Začitowanje strony je so njeporadźiło.',
	'includewp-licence-notice' => 'Wyši wobsah pochadźa ze strony $1 <a href="$2">$3</a> steji pod licencu <a href="$4">$5</a>. Dospołna lisćina awtorow je <a href="$6">tu</a> k dispoziciji.',
	'includewp-parserhook-desc' => 'Parserowa hóčka, kotraž zwobraznjenje wobsaha strony Wikipedije zmóžnja.',
	'includewp-include-par-page' => 'Mjeno strony, kotraž ma so zwobraznić.',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'includewp-desc' => 'IncludeWP es un extension legier pro includer contento de Wikipedia',
	'includewp-loading-page' => 'Carga pagina…',
	'includewp-show-full-page' => 'Monstra pagina complete',
	'includewp-show-fragment' => 'Monstrar solmente le prime paragrapho',
	'includewp-loading-failed' => 'Cargamento del pagina fallite.',
	'includewp-licence-notice' => 'Le contento hic supra proveni del pagina <a href="$2">$3</a> de $1, e es disponibile sub licentia <a href="$4">$5</a>. Un lista complete de autores se trova <a href="$6">hic</a>.',
	'includewp-parserhook-desc' => 'Uncino del analysator syntactic que permitte presentar contento de un pagina de Wikipedia.',
	'includewp-include-par-page' => 'Le nomine del pagina (remote) a presentar.',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'includewp-desc' => 'IncludeWP ass eng einfach Erweiderung fir Wikipedia Inhalt anzebannen',
	'includewp-loading-page' => "D'Säit gëtt gelueden...",
	'includewp-show-full-page' => 'Säit ganz weisen',
	'includewp-show-fragment' => 'Nëmmen den éischte Abschnitt weisen',
	'includewp-loading-failed' => "D'Säit konnt net geluede ginn.",
	'includewp-include-par-page' => 'Den Numm vun der Säit (vun der anerer Wiki), déi Dir wëllt gewise kréien.',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'includewp-desc' => 'IncludeWP е едноставен додаток за вклучување на содржини од Википедија',
	'includewp-loading-page' => 'Ја вчитувам страницата...',
	'includewp-show-full-page' => 'Прикажи цела страница',
	'includewp-show-fragment' => 'Прикажи го само првиот пасус',
	'includewp-loading-failed' => 'Не успеав да ја вчитам страницата.',
	'includewp-licence-notice' => 'Горенаведената содржина е преземена од страницата $1 <a href="$2">$3</a> која е под лиценцата <a href="$4">$5</a>. Целосен список на автори ќе најдете <a href="$6">тука</a>.',
	'includewp-parserhook-desc' => 'Парсерската кука што овозможува секогаш да се прикажува содржина на страница од Википедија.',
	'includewp-include-par-page' => 'Името на онаа (далечинска) страница што сакате да се прикаже.',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'includewp-desc' => 'IncludeWP é uma extensão ligeira para inclusão de conteúdo da Wikipédia',
	'includewp-loading-page' => 'A carregar a página...',
	'includewp-show-full-page' => 'Mostrar a página inteira',
	'includewp-show-fragment' => 'Mostrar só o primeiro parágrafo',
	'includewp-loading-failed' => 'Não foi possível carregar a página.',
	'includewp-licence-notice' => 'O conteúdo acima provém da página <a href="$2">$3</a> da $1, licenciada com a <a href="$4">$5</a>. Pode encontrar uma lista completa dos autores <a href="$6">aqui</a>.',
	'includewp-parserhook-desc' => 'Hook do analisador sintáctico para apresentar o conteúdo de uma página da Wikipédia.',
	'includewp-include-par-page' => 'O nome da página (remota) que pretende apresentar.',
);

/** Russian (Русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'includewp-desc' => 'IncludeWP — это лёгкое расширение для включения содержания Википедии',
	'includewp-loading-page' => 'Загрузка страницы…',
	'includewp-show-full-page' => 'Показать полную страницу',
	'includewp-show-fragment' => 'Показывать только первый абзац',
	'includewp-loading-failed' => 'Ошибка загрузки страницы.',
	'includewp-licence-notice' => 'Приведённый выше материал получен со страницы <a href="$2">$3</a> проекта $1, он доступен на условиях <a href="$4">$5</a>. Полный список авторов можно найти <a href="$6">здесь</a>.',
	'includewp-parserhook-desc' => 'Обработчик парсера, позволяющий отображать содержание Википедии.',
	'includewp-include-par-page' => 'Имя страницы (в другом проекте), которую вы хотите отобразить.',
);

/** Ukrainian (Українська)
 * @author Тест
 */
$messages['uk'] = array(
	'includewp-loading-page' => 'Завантаження сторінки...',
	'includewp-show-full-page' => 'Показати всю сторінку',
	'includewp-show-fragment' => 'Показувати лише перший абзац',
	'includewp-loading-failed' => 'Не вдалося завантажити сторінку.',
	'includewp-include-par-page' => 'Назва (віддаленої) сторінки, яку ви хочете показати.',
);

